#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Rotation through TranslationMod01.fsh   by  Mx7f   
//https://www.shadertoy.com/view/lds3Wl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Tweak these to get different results
const int   NUM_CIRCLES 	= 37;
const float TIME_MULTIPLIER = 3.0;
const float CIRCLE_RADIUS   = 0.04;
const float CONSTANT_N	    = 3.0;

// Uncomment to let N vary wildly instead of be CONSTANT_N 
// I recommend you use a large NUM_CIRCLES with this
//#define LET_N_GO_NUTS

// Uncomment to make the circles have color
//#define COLORIZE 

// Comment out to get rid of the lines
#define SHOW_LINES


float N = CONSTANT_N;


// Actual code below

#define TWO_PI 6.28318530718
#define TWO_THIRDS_PI 2.09439510239

vec3 drawCircle(vec2 p, vec2 center, float radius, float edgeWidth, vec3 color) {
	return color*(1.0-smoothstep(radius, radius+edgeWidth, length(p-center)));
}

vec3 drawLine(vec2 p, float angle, float thickness, float edgeWidth, vec3 color) {
	return color*(1.0-smoothstep(thickness, thickness + edgeWidth, 
								 abs(sin(angle)*p.x+cos(angle)*p.y)));	
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
#ifdef LET_N_GO_NUTS
	float N = sin(iTime)*2.0 + 3.0; 
#endif
    
	// Map coordinates into a small window around [-1, 1]
	vec2 uv = (fragCoord.xy*2.0 - iResolution.xy) / iResolution.y;
	uv *= 1.2;
	
	vec3 color = vec3(0.0);
	float angleIncrement = TWO_PI / float(NUM_CIRCLES);
	for (int i = 0; i < NUM_CIRCLES; ++i) {
		float t = angleIncrement*(float(i));
		float r = sin(float(N)*t+iTime*TIME_MULTIPLIER);
		vec2 p = vec2(r*cos(t), r*sin(t));
#ifdef COLORIZE
		vec3 circleColor = vec3(sin(t),
								sin(t+TWO_THIRDS_PI),
								sin(t+2.0*TWO_THIRDS_PI))*0.5+0.5;
#else
		vec3 circleColor = vec3(1.0);
		
#endif
		color += drawCircle(uv, p, CIRCLE_RADIUS, 0.01, circleColor);
		
#ifdef SHOW_LINES 
		color += drawLine(uv, t, 0.000, 0.01, vec3(1.0,0.0,0.0));
#endif
	}
	
	
	fragColor = vec4(color,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

